;; This example shows how to read a sector from
;; a DATA format disc
;;
;; This code is public domain and can be used in your
;; own programs.
;; 
;; Written by Kevin Thacker, 2002.
;;
;;------------------------------------------------

;; firmware function to find a RSX
.kl_find_command equ &bcd4

org &8000
nolist

;;------------------------------------------------
;; find BIOS: READ SECTOR command
;;
;; This method is compatible with other DOSs that
;; override or provide this command. If the command
;; is not found, then there is no furthur action. Therefore
;; on tape based systems, this code will have no effect.

ld hl,cmd_bios_read_sector
call kl_find_command
ret nc

;; command found

;; store address of command
ld (bios_read_sector),hl

;; store "rom select" of command
ld a,c
ld (bios_read_sector+2),a

;;------------------------------------------------------------------
;; read 512 bytes of data from track 0, sector &C1 from disc drive 0

;; HL = address of buffer
;; (change this value to define a different buffer address)
ld hl,buffer

;; E = drive number (0 or 1)
;; (change this value to define the disc drive to read from)
ld e,0

;; D = track number
;; (change this value to define the track to read from)
ld d,0

;; C = sector id
;; 
;; sector ids for DATA format disc: &C1, &C2, &C3, &C4, &C5, &C6, &C7, &C8, &C9
;; sector ids for SYSTEM/VENDOR format disc: &41, &42, &43, &44, &45, &46, &47, &48, &49
;;
;; (change this value to define the id of the sector to read from)
ld c,&c1

;; execute command
rst 3
defw bios_read_sector

ret

;;------------------------------------------------------------------

;; this is initialised when the "BIOS: READ SECTOR" RSX has been found.
.bios_read_sector
defw 0                    ;; address of function
defb 0                    ;; "rom select" for function


.cmd_bios_read_sector
defb 4+&80				;; this is the "BIOS: READ SECTOR" RSX


;;------------------------------------------------------------------

.buffer 
defs 512
